# This proram demonstrates exception handling.

# The "main" function is where all of the action will take place.
def main():
    # Let's start off by creating a list to store test scores.
    tests = []
    # We'll also initialize a variable to store the total.
    total = 0
    # Now, we'll set up a "try" block. This is part of our exception handling routine.
    # The Python interpreter will test this block of code for errors. This includes
    # any input errors that may crop up.
    try:
        # Let's use a for loop to ask the user to enter 3 test scores.
        for i in range(0,3):
            # We'll convert each test score into a floating point number and append
            # it to our list.
            tests.append(float(input("Enter test " + str(i) + ": ")))
        # Let's use a second for loop to iterate through our list of test scores and
        # add them up to find the total.
        for score in tests:
            total += score
        # Now that we have the total, let's find the average by dividing the total by
        # the number of test scores in the list. We can use the len() function to find
        # the number of items in a list.
        average = total / len(tests)
        # Finally, let's print out the result.
        print("Your average is", f'{average:.2f}')
    # The "except" block is where we handle any errors that may have cropped up. For example,
    # if the user enters a string instead of a number, we won't be able to convert that into
    # a floating point number. In that case, we'll need to display an error. Note the use of
    # "Exception as e" in our except statement. This will store the actual exception so that
    # we can print it out as part of our error message.
    except Exception as e:
        # First, we'll print a more user friendly error message.
        print("I'm sorry, but we ran into a problem.")
        # Then, we'll print out the actual error that occurred.
        print(e)
    # The "finally" block is a block of code that will be executed regardless of whether the
    # Python interpreter encountered any errors.
    finally:
        print("Thank you for your input.")

if __name__=='__main__':
    main()
